program sample5;

{-------------------------------------------------------}
{ DR. JOHANNES HEIDENHAIN GmbH, Traunreut, Germany      }
{                                                       }
{ Axis 1 in Interpolation Mode                          }
{                                                       }
{ V 1.00                                                }
{ July 1994                                             }
{-------------------------------------------------------}


{$N+,E+}
{$V+}
{$R+}

uses crt,ik121_1;

var
  board                   : ik121_pointr;
  axis1,axis2           : g26_pointr;
  ende                    : boolean;
  reg                     : word;
  eing                    : char;
(*________________________________________*)
procedure main;
var
  p,i  : comp;

begin
  clrscr;

  board^.axis[1]^.inimain.mode1024:=true;
  board^.axis[1]^.inimain.en_48bit:=false;
  Init_Handler(board^.axis[1]);

  textcolor(15);
  writeln(' Interpolation Mode');
  writeln;
  writeln(' Start counter                        ->Press a ');
  writeln(' Reset counter                        ->Press b ');
  writeln(' Stop counter                         ->Press c ');
  writeln(' Software latch in register 1         ->Press d ');
  writeln(' Special software latch in register 1 ->Press e ');
  writeln(' Start with ref                       ->Press h ');
  writeln(' Start and reset with ref             ->Press i ');
  writeln(' Stop with ref                        ->Press j ');
  writeln(' Latch in register 1 with ref         ->Press k ');
  writeln(' Latch in register 1 with ref 2       ->Press l ');
  writeln(' Reset with ref                       ->Press m ');
  writeln;
  writeln(' Quit                                 ->Press q ');
  textcolor(4);

  ende:=false;
  repeat
    eing:=#32;
    delay(500);

    (* Read status *)
    read_count_status(board^.axis[1]);
    gotoxy(45,18);
    textcolor(1);
    if board^.axis[1]^.cstatus.latch0 then write('Latch0') else write('      ');
    gotoxy(45,19);
    if board^.axis[1]^.cstatus.latch1 then write('Latch1') else write('      ');
    gotoxy(45,20);
    if board^.axis[1]^.cstatus.stop then write('Stop') else write('      ');
    textcolor(4);

    (* Read status bit for "latched" and read data register *)
    Read_Reg0(board^.axis[1]);
    Read_Reg1(board^.axis[1]);

    (* Display registers on screen *)
    gotoxy(1,17);
    writeln(' Axis 1 - Reg0:  ',board^.axis[1]^.register0:10:0,'            ');
    writeln(' Axis 1 - Reg1:  ',board^.axis[1]^.register1:10:0,'            ');

    gotoxy(1,20);
    p:=int(board^.axis[1]^.register0/1024);
    writeln(' Axis 1 - Reg0 - Periode:  ',p:10:0,'       ');
    i:=board^.axis[1]^.register0-(p*1024);
    writeln(' Axis 1 - Reg0 - Interp.:  ',i:10:0,'       ');

    (* Software latch *)
    Soft_latch0(board^.axis[1]);

    if keypressed then eing:=readkey;
    case eing of
      'a': begin
             board^.axis[1]^.softcomm.start:=true;
             Comm_Handler(board^.axis[1]);
           end;
      'b': begin
             board^.axis[1]^.softcomm.clear:=true;
             Comm_Handler(board^.axis[1]);
           end;
      'c': begin
             board^.axis[1]^.softcomm.stop:=true;
             Comm_Handler(board^.axis[1]);
           end;
      'd': begin
             board^.axis[1]^.softcomm.latch1:=true;
             Comm_Handler(board^.axis[1]);
           end;
      'e': begin
             board^.axis[1]^.inilatch.en_latch2_reg1:=true;
             Init_Handler(board^.axis[1]);
             board^.axis[1]^.softcomm.latch2:=true;
             Comm_Handler(board^.axis[1]);
           end;
      'h': begin
             board^.axis[1]^.refcomm.ristart:=true;
             Comm_Handler(board^.axis[1]);
           end;
      'i': begin
             board^.axis[1]^.refcomm.ristart:=true;
             board^.axis[1]^.refcomm.riclear:=true;
             Comm_Handler(board^.axis[1]);
           end;
      'j': begin
             board^.axis[1]^.refcomm.ristop:=true;
             Comm_Handler(board^.axis[1]);
           end;
      'k': begin
             board^.axis[1]^.inimain.sel_ri_1st:=true;
             Init_Handler(board^.axis[1]);
             board^.axis[1]^.refcomm.rilatch:=true;
             Comm_Handler(board^.axis[1]);
           end;
      'l': begin
             board^.axis[1]^.inimain.sel_ri_2nd:=true;
             Init_Handler(board^.axis[1]);
             board^.axis[1]^.refcomm.rilatch2:=true;
             Comm_Handler(board^.axis[1]);
           end;
      'm': begin
             board^.axis[1]^.refcomm.riclear2:=true;
             Comm_Handler(board^.axis[1]);
           end;
      'q': begin
             ende:=true;
           end;
     end;
  until ende;
end;
(*________________________________________*)
begin
  textbackground(7);
  clrscr;
  New(board);
  New(axis1);
  New(axis2);
  board^.axis[1]:=axis1;
  board^.axis[2]:=axis2;
  init_ik121(board);
  if (look_for_ik121(board)) then
    begin
      main;
    end
  else
    begin
      clrscr;
      write('No hardware!!');;
      readln;
    end;

  Dispose(board);
  Dispose(axis1);
  Dispose(axis2);
  textbackground(0);
  clrscr;
end.
(*________________________________________*)